<?php
use Carbon\Carbon;
use Carbon\CarbonImmutable;

class project extends base {
	
	
	public $mailer = null;
	
	
	/**
	* @access public
	* @return void
	*/
	public function initialize_mailer() {
		//initialize mailer object
		if (!is_object($this->mailer)) {
			require_once 'PHPMailer.php';
			require_once 'SMTP.php';
			//initialize object
			$this->mailer = new PHPMailer(true);
		}
	}

	
	 /**
	 * @param int $department_id
	 * @param string $subject
	 * @param string $body
	 * @param string $email
	 * @param string $name          (optional)
	 */

	public function send_email($department_id, $subject, $body, $email, $name='') {
		$emailServers = $this->rows('email_server');
		if (count($emailServers)) {
			$emailServer = array_shift($emailServers);
			$sender = $this->row('departments', 'WHERE id=:id', [":id" => $department_id]);
			try {
				$this->initialize_mailer();
				$this->mailer->isSMTP();                                     // Set this->mailer to use SMTP
				$this->mailer->Host = $emailServer['smtp_host'];             // Specify main and backup SMTP servers
				$this->mailer->SMTPAuth = true;                              // Enable SMTP authentication
				$this->mailer->Username = $emailServer['smtp_username'];     // SMTP username
				$this->mailer->Password = $emailServer['smtp_password'];     // SMTP password
				$this->mailer->SMTPSecure = $emailServer['smtp_encryption']; // Enable TLS encryption, `ssl` also accepted
				$this->mailer->Port = $emailServer['smtp_port'];             // TCP port to connect to
				$this->mailer->addReplyTo($sender['smtp_username'], $sender['department_name']);
				$this->mailer->setFrom($sender['smtp_username'], $sender['department_name']);
				$this->mailer->addAddress($email, $name);
				$this->mailer->isHTML(true); // Set email format to HTML
				$this->mailer->Subject = $subject;
				$this->mailer->Body    = $body;
				$this->mailer->send();
				$this->mailer->smtpClose();
				$this->mailer = null;
			}catch (Exception $e) {
				echo $this->mailer->ErrorInfo;
			}
		}
	}



	/**
	 * broadcastEmail
	 * @param int $complinId
	 * @param string $status
	 * @param string $message
	 * @param array $session_data
	 * @return boolen
	 */
	 
	public function broadcastEmail($complinId,$status,$message,$session_data, $active_complain = 1){
		$complain = $this->row('complains', 'WHERE id=:id', [":id" => $complinId]);
		$customer = $this->row('customers', 'WHERE id=:id', [":id" => $complain['customer_id']])['name'];
		$broadcastEmails = $this->rows('broadcast_email');
		if(count($broadcastEmails)){
			$broadcastEmail = array_shift($broadcastEmails);
			$department_id = $session_data['department_id'];
			$subject = 'Complain ID: ' . $complinId . ' || ' . $status . ' || ' . $customer;
			$request_scheme = $_SERVER['REQUEST_SCHEME'];
			$server_name = $_SERVER['SERVER_NAME'];
			if($active_complain){
			$body ="<p>$message</p>
				   <p>&nbsp;</p>
				   <a href=\"$request_scheme://$server_name/active-complain-details.php?id=$complinId\">Details</a>
				   ";
			}else{
				$body = "<p>$message</p>
						<p>&nbsp;</p>
						";
			}
			$toEmails = explode(';', $broadcastEmail['smtp_username']);
			foreach($toEmails as $toEmail){
				$this->send_email($department_id, $subject, $body, $toEmail, $name='');
			}
		}
	}
	
	
	
	
    /**
	 * check duplicate
	 * @param string $table        (optional)
	 * @param string $column       (optional)
	 * @param string $column_value (optional)
	 * @param int $operator_id  (optional)
	 * @return boolen
	 */
	public function is_duplicate($table='', $column='', $column_value='') {
		$count=0;
		$filter_string='WHERE '.$column.'=:column_value';
		$filter_value=[":column_value" => $column_value];
		$count=$this->count_row($table, $filter_string, $filter_value);
		return ($count) ? true : false;
	}
	
	
	/**
	 *
	 * @ friendly name lib
	 * @access public
	 */
	public $friendly_name=[
		'month_end' => 'Month-end',
		'due_date'  => 'Due Date'
	];



	/**
	 *
	 * @ column type
	 * @access public
	 */
	public $column_type = [
		'date_of_birth' => 'date',
		'birth_date' => 'date',
		'hire_date' => 'date',
		'due_date' => 'date'
	];



	/**
	 *
	 * @ return friendly name
	 * @access public
	 * @param string $key
	 * @return string
	 */
	public function get_friendly_name($key) {
		$keys = array_keys($this->friendly_name);
		if (in_array($key, $keys)) {
			return $this->friendly_name[$key];
		} else {
			return $key;
		}
	}



	/**
	 *
	 * @ return column type
	 * @access public
	 * @param string $column
	 * @return string
	 */
	public function get_column_type($column) {
		$keys = array_keys($this->column_type);
		if (in_array($column, $keys)) {
			return $this->column_type[$column];
		} else {
			return 'text';
		}
	}




	/**
	 * resets connection.
	 * @access public
	 * @return void
	 */
	public function reset_conn() {
		$this->mypdo=null;
	}




	/**
	 * reset infodb connection.
	 * @access public
	 * @return void
	 */
	public function reset_infodb_conn() {
		$this->infopdo=null;
	}




	/**
	 * return staff row
	 * Return False if no data
	 * @access public
	 * @param int     $staff_id (optional)
	 * @return array
	 */
	public function staff_data($staff_id='') {
		$value=[":id" => $staff_id];
		$this->get_connection();
		$statement=$this->mypdo->prepare('SELECT * FROM `staffs` WHERE id=:id');
		$statement->execute((array)$value);
		return $statement->fetch(PDO::FETCH_ASSOC);
	}
	
	
	
	/**
	*get tables that has complain_id
	*@return array
	*/
	public function get_complain_id_tables(){
		return $this->get_tables('complain_id');
	}
	
	
	
	/**
	* delete complain
	* @access public
	*/
	public function delete_complain($complain_id, $session_data) {
		//delete complain tables
		$tables=$this->get_complain_id_tables();
		foreach ($tables as $table) {
			$this->delete_row($table, 'WHERE complain_id=:complain_id', [":complain_id" => $complain_id], $session_data);
		}
		//delete complain
		$this->delete_row('complains', 'WHERE id=:id', [":id" => $complain_id], $session_data);
		return 0;
	}
	
	
	/**
	*get tables that has staff_id
	*@return array
	*/
	public function get_staff_id_tables(){
		return $this->get_tables('staff_id');
	}
	
	
	
	/**
	* delete complain
	* @access public
	*/
	public function delete_staff($staff_id, $session_data) {
		//delete complain tables
		$tables=$this->get_staff_id_tables();
		foreach ($tables as $table) {
			$this->delete_row($table, 'WHERE staff_id=:staff_id', [":staff_id" => $staff_id], $session_data);
		}
		//delete complain
		$this->delete_row('staffs', 'WHERE id=:id', [":id" => $staff_id], $session_data);
		return 0;
	}
	
	
	/**
	*get tables that has customer_id
	*@return array
	*/
	public function get_customer_id_tables(){
		return $this->get_tables('customer_id');
	}
	
	
	
	/**
	* delete complain
	* @access public
	*/
	public function delete_customer($customer_id, $session_data) {
		//delete complain tables
		$tables=$this->get_customer_id_tables();
		foreach ($tables as $table) {
			$this->delete_row($table, 'WHERE customer_id=:customer_id', [":customer_id" => $customer_id], $session_data);
		}
		//delete complain
		$this->delete_row('customers', 'WHERE id=:id', [":id" => $customer_id], $session_data);
		return 0;
	}
	
	
	
	
	/**
	 * insert friendly log
	 * @param text $log
	 * @param array $session_data
	 * @access public
	 */
	 public function insert_friendly_log($log=[],$session_data){
		 if(count($session_data)){
			 $staff_id=$session_data['id'];
			 $log=json_encode($log);
			 $post_data=[
			 "staff_id" => $staff_id,
			 "friendly_log" => $log
			 ];
			 $this->insert('friendly_logs',$post_data,$session_data,false);
			 return 1;
		 }
		 return 0;
	 }
	 
	
	/**
	 * @return performance_name
	 * @param int $performance_value
	 * @access public
	 */
	public function performance_name($performance_value){
		switch($performance_value){
			case '5':
			return 'Very Satisfied';
			case '4':
			return 'Satisfied';
			case '3':
			return 'OK';
			case '2':
			return 'Dissatisfied';
			case '1':
			return 'Very Dissatisfied';
			default:
			return 'Undefined';
		}
	}
	
	
	/**
	 * @return performance_name
	 * @param int $performance_value
	 * @access public
	 */
	public function getWeekDates($year, $week){
		$from = date("Y-m-d", strtotime("{$year}-W{$week}-1")); //Returns the date of monday in week
		$to = date("Y-m-d", strtotime("{$year}-W{$week}-7"));   //Returns the date of sunday in week
		return $from . ' - ' . $to;
	}
	
	
	
	/**
	 * @return performance_name
	 * @param int $performance_value
	 * @access public
	 */
	public function activeComplainAge($complain_id){
		$complain = $this->row('complains','WHERE id=:id',[":id" => $complain_id]);
		$start_time = new DateTime($complain['start_time']);
		$end_time =  new DateTime(date(APP_DATE_TIME_FORMAT));
		$interval =  $start_time->diff($end_time);
		#Intervarl in Second
		$interval_s = round($interval->format('%s'));
		#Intervarl in Minute
		$interval_i = round($interval->format('%i'));
		#Intervarl in Hour
		$interval_h = round($interval->format('%h'));
		#Intervarl in Day
		$interval_d = round($interval->format('%a'));
		return $interval_d . ' Day '. $interval_h . ' Hour ' . $interval_i . ' Minute';
	}
	
	
	
	/**
	 * @return mixed
	 * @param int $complain_id
	 * @access public
	 */
	public function isComplainOverdue($complain_id){
		$complain = $this->row('complains','WHERE id=:id',[":id" => $complain_id]);
		$allocated_time = $this->row('complain_categories','WHERE id=:id',[":id" => $complain['category_id']])['time_duration_m'];
		//Elapsed time
		$start_time = new DateTime($complain['start_time']);
		$end_time =  new DateTime(date(APP_DATE_TIME_FORMAT));
		$interval =  $start_time->diff($end_time);
		#Intervarl in Second
		$interval_s = round($interval->format('%s'));
		#Intervarl in Minute
		$interval_i = round($interval->format('%i'));
		#Intervarl in Hour
		$interval_h = round($interval->format('%h'));
		#Intervarl in Day
		$interval_d = round($interval->format('%a'));
		$elapsed_time = $interval_i + ($interval_h*60) + ($interval_d*1440);
		if($elapsed_time > $allocated_time){
			$overdue = $elapsed_time - $allocated_time;
			$overdue_i = 0;
			$overdue_h = 0;
			$overdue_d = 0;
			while($overdue){
				while($overdue>1440){
					$overdue_d++;
					$overdue = $overdue - 1440;
				}
				while($overdue>=60){
					$overdue_h++;
					$overdue = $overdue - 60;
				}
				$overdue_i = $overdue;
				$overdue = 0;
			}
			
			$overdue = $overdue_d.' days '.$overdue_h.' hours '.$overdue_i.' minutes';
			$date = CarbonImmutable::now();
			return $date->sub($overdue)->calendar();
		}else{
			return 0;
		}
		
	}
	
	

	/*End of Class*/ }
?>