 <?php 
/*
#File: dashboard.php
#version: 1.2
#Last Modified: 24-Feb-2020
#Creator: Md. Sohag Hosen
#sohag1426@gmail.com
*/
  $section_value=['0' => 1];
  include 'header.php';
  use Carbon\Carbon;
  use Carbon\CarbonImmutable;
  ?>
  <section class="content-header">
    <h1>
      Dashboard
    </h1>
  </section>
  <!-- Main content -->
  <section class="content">
  
  
    <!--at a glance information-->
    <div class="box box-solid box-success">
      <div class="box-body">
        <div class="row">
          <!--active-complain-->
          <div class="col-lg-4 col-xs-6">
            <div class="small-box bg-yellow">
              <div class="inner">
                <h3>
                  <?php
				      $complains=0;
					  $complains=$dbo->count_row('complains');
                    echo $complains;
                    ?>
                  </h3>
                  <p>Active Complain</p>
                </div>
                <div class="icon">
                  <i class="fa  fa-telegram"></i>
                </div>
                <a href="active-complains.php" class="small-box-footer">View Complains<i class="fa fa-arrow-circle-right"></i></a>
              </div>
            </div>
            <!--/active-complain-->
          </div>
          <!--/row-->
        </div>
        <!-- /box-body -->
      </div>
      <!--/box solid-->
	  
	  
      
<div class="row">
  <div class="col-xs-12">
    <!--Box Component-->
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">Complains by Category</h3>
      </div>
      <!-- /box-header -->
      <div class="box-body">
        <table  class="table table-bordered table-striped">
          <thead>
            <tr>
              <th>Category</th>
              <th>No. of Complains</th>
            </tr>
          </thead>
          <tbody>
            <?php
		     $rows=$dbo->select('SELECT category_id, COUNT(category_id) as no_of_complain FROM `complains` GROUP by category_id');
              while($row=array_shift($rows)){ ?>
              <tr>
                <td><?php echo $dbo->row('complain_categories','WHERE id=:id',[":id" => $row['category_id']])['complain_category']; ?></td>
                  <td><?php echo $row['no_of_complain']; ?></td>
                  </tr>
                  <?php	}/*End of Loop*/  ?>
                  </tbody>
                </table>
              </div>
              <!-- /box-body -->
            </div>
            <!-- /box -->
          </div>
          <!--/col-xs-12-->
        </div>
        <!--/row -->

			  
 <?php
//threedaybefore
$dt = Carbon::create(date(APP_DATE_FORMAT));
$threedaybefore = $dt->subDays(3);
$threedaybefore = date_format(date_create($threedaybefore), APP_DATE_FORMAT);
$threedaybefore = Carbon::create($threedaybefore);
//sevendaybefore
$dt = Carbon::create(date(APP_DATE_FORMAT));
$sevendaybefore = $dt->subDays(7);
$sevendaybefore = date_format(date_create($sevendaybefore), APP_DATE_FORMAT);
$sevendaybefore = Carbon::create($sevendaybefore);
$rows = $dbo->rows('complains');
$greaterThan7DaysOld=[];
$between3And7DaysOld=[];
$lessThan3DaysOld=[];
while ($row = array_shift($rows)) {
	$complaint_date = Carbon::create($row['start_date']);
	if ($complaint_date->lessThan($sevendaybefore)) {
		$greaterThan7DaysOld[]=$row;
	}elseif ($complaint_date->greaterThanOrEqualTo($sevendaybefore) && $complaint_date->lessThanOrEqualTo($threedaybefore)) {
		$between3And7DaysOld[]=$row;
	}else {
		$lessThan3DaysOld[] = $row;
	}
}
?>

  <div class="row">
	<div class="col-xs-12">
                 
<!--Box Component-->
<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title"><span class="label label-danger">Complaint Age Greater Than 7 Days</span></h3>
  </div>
  <!-- /box-header -->
  <div class="box-body">
    <div class="modal fade" id="modal-default">
    </div>
    <!-- /modal -->
    <div  <?php if ($dbo->is_mobile()) { echo ' class="table-responsive"'; }?>>
      <table  class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th>Customer</th>
            <th>Department</th>
            <th>Category</th>
            <th>Time</th>
            <th>Status</th>
            <th>Ack. By</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php
            while($row=array_shift($greaterThan7DaysOld)){
                $customer = $dbo->row('customers','WHERE id=:id',[":id" => $row['customer_id']]);
				$department = $dbo->row('departments','WHERE id=:id',[":id" => $row['care_of_gid']])['department_name'];
            ?>
            <tr>
              <td><?php echo $row['id']; ?></td>
                <td><a href="customer-profile.php?id=<?php echo $customer['id'];?>" onclick="basicPopup(this.href);return false" ><?php echo substr($customer['name'], 0, 25) . '...' ; ?></a></td>
                  <td><?php echo $department; ?></td>
                    <td>
                      <?php echo $dbo->row('complain_categories','WHERE id=:id',[":id" => $row['category_id']])['complain_category']; ?>
                      </td>
                      <td><?php echo '<b>Start Time: </b>' . $row['start_time'] . '</br>' . '<b>Age: </b>' . $dbo->activeComplainAge($row['id']); ?></td>
                    <?php if($row['ticket_status']=='On Hold'){ ?>
                      <td><span class="label label-warning">On Hold</span></td>
                      <?php }else{ ?>
                        <td><span class="label label-success"> In Progress </span></td>
                        <?php } ?>
                          <?php if($row['ack_status']){
								  $acknowledge_by = $dbo->row('staffs','WHERE id=:id',[":id" => $row['acknowledge_by']]);
                            ?>
                            <td>
                              <a href="care-of-profile.php?id=<?php echo $acknowledge_by['id'];?>" onclick="basicPopup(this.href);return false" ><?php echo $acknowledge_by['username']; ?></a>
                              </td>
                              <td>
                                <a href="active-complain-details.php?id=<?php echo $row['id'];?>" class="btn btn-primary a-btn-slide-text">
                                  <span class="fa  fa-view" aria-hidden="true"></span>
                                  <span><strong>Details</strong></span>
                                </a>
                              </td>
                              <?php }else{ ?>
                                <td><span class="label label-warning">New</span></td>
                                <td>
                                  <a href="active-complain-details.php?id=<?php echo $row['id'];?>" class="btn btn-primary a-btn-slide-text">
                                    <span class="fa  fa-view" aria-hidden="true"></span>
                                    <span><strong>Details</strong></span>
                                  </a>
                                  <a href="acknowledge-complain.php?id=<?php echo $row['id'];?>&gid=<?php echo $gid;?>" class="btn btn-primary a-btn-slide-text">
                                      <span class="fa  fa-view" aria-hidden="true"></span>
                                      <span><strong>Acknowledge</strong></span>
                                    </a>
                                  </td>
                                  <?php } ?>
                                  </tr>
                                  <?php	/*End of Loop*/ } ?>
                                  </tbody>
                                </table>
                              </div>
                              <!--/table-responsive-->
                            </div>
                            <!-- /box-body -->
                          </div>
                          <!-- /box -->

											  
											  
										<!--Box Component-->
<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title"><span class="label label-warning">Complaint Age Between 3 and 7 Days</span></h3>
  </div>
  <!-- /box-header -->
  <div class="box-body">
    <div class="modal fade" id="modal-default">
    </div>
    <!-- /modal -->
    <div  <?php if ($dbo->is_mobile()) { echo ' class="table-responsive"'; }?>>
      <table  class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th>Customer</th>
            <th>Department</th>
            <th>Category</th>
            <th>Time</th>
            <th>Status</th>
            <th>Ack. By</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php
            while($row=array_shift($between3And7DaysOld)){
                $customer = $dbo->row('customers','WHERE id=:id',[":id" => $row['customer_id']]);
				$department = $dbo->row('departments','WHERE id=:id',[":id" => $row['care_of_gid']])['department_name'];
            ?>
            <tr>
              <td><?php echo $row['id']; ?></td>
                <td><a href="customer-profile.php?id=<?php echo $customer['id'];?>" onclick="basicPopup(this.href);return false" ><?php echo substr($customer['name'], 0, 25) . '...' ; ?></a></td>
                  <td><?php echo $department; ?></td>
                    <td>
                      <?php echo $dbo->row('complain_categories','WHERE id=:id',[":id" => $row['category_id']])['complain_category']; ?>
                      </td>
                      <td><?php echo '<b>Start Time: </b>' . $row['start_time'] . '</br>' . '<b>Age: </b>' . $dbo->activeComplainAge($row['id']); ?></td>
                    <?php if($row['ticket_status']=='On Hold'){ ?>
                      <td><span class="label label-warning">On Hold</span></td>
                      <?php }else{ ?>
                        <td><span class="label label-success"> In Progress </span></td>
                        <?php } ?>
                          <?php if($row['ack_status']){
								  $acknowledge_by = $dbo->row('staffs','WHERE id=:id',[":id" => $row['acknowledge_by']]);
                            ?>
                            <td>
                              <a href="care-of-profile.php?id=<?php echo $acknowledge_by['id'];?>" onclick="basicPopup(this.href);return false" ><?php echo $acknowledge_by['username']; ?></a>
                              </td>
                              <td>
                                <a href="active-complain-details.php?id=<?php echo $row['id'];?>" class="btn btn-primary a-btn-slide-text">
                                  <span class="fa  fa-view" aria-hidden="true"></span>
                                  <span><strong>Details</strong></span>
                                </a>
                              </td>
                              <?php }else{ ?>
                                <td><span class="label label-warning">New</span></td>
                                <td>
                                  <a href="active-complain-details.php?id=<?php echo $row['id'];?>" class="btn btn-primary a-btn-slide-text">
                                    <span class="fa  fa-view" aria-hidden="true"></span>
                                    <span><strong>Details</strong></span>
                                  </a>
                                  <a href="acknowledge-complain.php?id=<?php echo $row['id'];?>&gid=<?php echo $gid;?>" class="btn btn-primary a-btn-slide-text">
                                      <span class="fa  fa-view" aria-hidden="true"></span>
                                      <span><strong>Acknowledge</strong></span>
                                    </a>
                                  </td>
                                  <?php } ?>
                                  </tr>
                                  <?php	/*End of Loop*/ } ?>
                                  </tbody>
                                </table>
                              </div>
                              <!--/table-responsive-->
                            </div>
                            <!-- /box-body -->
                          </div>
                          <!-- /box -->

																		
<!--Box Component-->
<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title"><span class="label label-success">Complaint Age Less Than 3 Days</span></h3>
  </div>
  <!-- /box-header -->
  <div class="box-body">
    <div class="modal fade" id="modal-default">
    </div>
    <!-- /modal -->
    <div  <?php if ($dbo->is_mobile()) { echo ' class="table-responsive"'; }?>>
      <table  class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th>Customer</th>
            <th>Department</th>
            <th>Category</th>
            <th>Time</th>
            <th>Status</th>
            <th>Ack. By</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php
            while($row=array_shift($lessThan3DaysOld)){
                $customer = $dbo->row('customers','WHERE id=:id',[":id" => $row['customer_id']]);
				$department = $dbo->row('departments','WHERE id=:id',[":id" => $row['care_of_gid']])['department_name'];
            ?>
            <tr>
              <td><?php echo $row['id']; ?></td>
                <td><a href="customer-profile.php?id=<?php echo $customer['id'];?>" onclick="basicPopup(this.href);return false" ><?php echo substr($customer['name'], 0, 25) . '...' ; ?></a></td>
                  <td><?php echo $department; ?></td>
                    <td>
                      <?php echo $dbo->row('complain_categories','WHERE id=:id',[":id" => $row['category_id']])['complain_category']; ?>
                      </td>
                      <td><?php echo '<b>Start Time: </b>' . $row['start_time'] . '</br>' . '<b>Age: </b>' . $dbo->activeComplainAge($row['id']); ?></td>
                    <?php if($row['ticket_status']=='On Hold'){ ?>
                      <td><span class="label label-warning">On Hold</span></td>
                      <?php }else{ ?>
                        <td><span class="label label-success"> In Progress </span></td>
                        <?php } ?>
                          <?php if($row['ack_status']){
								  $acknowledge_by = $dbo->row('staffs','WHERE id=:id',[":id" => $row['acknowledge_by']]);
                            ?>
                            <td>
                              <a href="care-of-profile.php?id=<?php echo $acknowledge_by['id'];?>" onclick="basicPopup(this.href);return false" ><?php echo $acknowledge_by['username']; ?></a>
                              </td>
                              <td>
                                <a href="active-complain-details.php?id=<?php echo $row['id'];?>" class="btn btn-primary a-btn-slide-text">
                                  <span class="fa  fa-view" aria-hidden="true"></span>
                                  <span><strong>Details</strong></span>
                                </a>
                              </td>
                              <?php }else{ ?>
                                <td><span class="label label-warning">New</span></td>
                                <td>
                                  <a href="active-complain-details.php?id=<?php echo $row['id'];?>" class="btn btn-primary a-btn-slide-text">
                                    <span class="fa  fa-view" aria-hidden="true"></span>
                                    <span><strong>Details</strong></span>
                                  </a>
                                  <a href="acknowledge-complain.php?id=<?php echo $row['id'];?>&gid=<?php echo $gid;?>" class="btn btn-primary a-btn-slide-text">
                                      <span class="fa  fa-view" aria-hidden="true"></span>
                                      <span><strong>Acknowledge</strong></span>
                                    </a>
                                  </td>
                                  <?php } ?>
                                  </tr>
                                  <?php	/*End of Loop*/ } ?>
                                  </tbody>
                                </table>
                              </div>
                              <!--/table-responsive-->
                            </div>
                            <!-- /box-body -->
                          </div>
                          <!-- /box -->
						  
						  
                        </div>
                        <!--/col-xs-12-->
                      </div>
                      <!--/row -->
                    </section>
                    <!-- /content -->
                    <!--footer-->
                    <?php include 'footer.php'; ?>
