<?php 
/*
#File: frequent-complaints.php
#version: 1.0;
#Last Modified: 24-Feb-2020
#Creator: Md. Sohag Hosen
#sohag1426@gmail.com
*/
$section_value=['1' => 1];
include 'header.php';
#page variables
$month = date_format(date_create(date(APP_DATE_FORMAT)),'M');
$year = date_format(date_create(date(APP_DATE_FORMAT)),'Y');
?>
<!-- Main content -->
    <section class="content">
	   <div class="row">
        <div class="col-xs-12">
		<!--form-->
        <form class="form-inline" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']);?>" method="get">
          <!--month-->
          <div class="form-group sm-6">
            <label for="month" class="sr-only">Month</label>
            <select name="month" id="month" class="form-control">
              <option value=''><--Select Month--></option>
                <option value='Jan'>January</option>
				<option value='Feb'>February</option>
				<option value='Mar'>March</option>
				<option value='Apr'>April</option>
				<option value='May'>May</option>
				<option value='Jun'>June</option>
				<option value='Jul'>July</option>
				<option value='Aug'>August</option>
				<option value='Sep'>September</option>
				<option value='Oct'>October</option>
				<option value='Nov'>November</option>
				<option value='Dec'>December</option>
              </select>
            </div>
            <!--/month-->
			
		<!--year-->
          <div class="form-group sm-6">
            <label for="year" class="sr-only">Year</label>
            <select name="year" id="year" class="form-control" required="">
			<option value=''><--Select Year--></option>
			<?php 
			for($i=2019;$i<=2030;$i++){
			echo '<option value='.$i.'>'.$i.'</option>';
			}
			?>
              </select>
            </div>
            <!--/year-->
            <!--submit button-->
            <button type="submit" class="btn bg-maroon sm-2">Filter</button>
            <!--/submit button-->
          </form>
          <!--/form-->
		  <?php
		  if(isset($_GET['month'])){
			  $month = $_GET['month'];
		  }
		  if(isset($_GET['year'])){
			  $year = $_GET['year'];
		  }
		  $filter_data['month']=$month;
		  $filter_data['year']=$year;
		  $filter=$dbo->array_to_and_filter('archived_complains', $filter_data);
		  $filter_string = $filter['string'];
	      $filter_value = $filter['value'];
		  ?>
        <!--Box Component-->
        <div class="box">
		<div class="box-header with-border">
            <h3 class="box-title"><li class="time-label"><?php echo 'Year: ' . $year . ', ' . 'month: ' . $month; ?></li></h3>
          </div>
          <div class="box-body">
            <table  class="table table-bordered table-striped">
              <thead>
                <tr>
                  <th>Customer</th>
                  <th>Complaint Frequency</th>
				  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <?php
				  $rows = $dbo->select('SELECT customer_id, COUNT(complain_id) as frequency FROM archived_complains '.$filter_string.' GROUP BY customer_id ORDER BY frequency DESC',$filter_value);
                  while($row=array_shift($rows)){
					  $customer = $dbo->row('customers','WHERE id=:id',[":id" => $row['customer_id']]);
					  ?>
                  <tr>
                    <td><a href="customer-profile.php?id=<?php echo $customer['id'];?>" onclick="basicPopup(this.href);return false" ><?php echo substr($customer['name'], 0, 25) . '...' ; ?></a></td>
                      <td><?php echo $row['frequency']; ?></td>
					  <td><a href="customer-complains.php?id=<?php echo $row['customer_id'];?>&month=<?php echo $month;?>&year=<?php echo $year; ?>">Details</a></td>
                          </tr>
                          <?php	} /*End of Loop*/ ?>
                          </tbody>
                        </table>
                      </div>
                      <!-- /box-body -->
                    </div>
                    <!-- /box -->
                  </div>
                  <!--/col-xs-12-->
                </div>
                <!--/row -->
				</section>
				<!-- /content -->
				<?php include 'footer.php'; ?>
				