<?php 
/*
#File: monthly-reports.php
#version: 1.1;
#Last Modified: 24-Feb-2020
#Creator: Md. Sohag Hosen
#sohag1426@gmail.com
*/
$section_value=['1' => 1];
include 'header.php';
//page variables
$years = [];
?>
<!-- Main content -->
     <section class="content">
	  <div class="row">
      <div class="col-xs-12">
	  
	   <!--form-->
        <form class="form-inline" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']);?>" method="get">
		<!--year-->
          <div class="form-group sm-6">
            <label for="year" class="sr-only">Year</label>
            <select name="year" id="year" class="form-control" required="">
			<option value=''><--Select Year--></option>
			<?php 
			for($i=2019;$i<=2030;$i++){
			echo '<option value='.$i.'>'.$i.'</option>';
			}
			?>
              </select>
            </div>
            <!--/year-->
            <!--submit button-->
            <button type="submit" class="btn bg-maroon sm-2">Filter</button>
            <!--/submit button-->
          </form>
          <!--/form-->
		  
	   <?php
	    if(isset($_GET['year']) && strlen($_GET['year'])){
			$years[] = $_GET['year'];
		}else{
			$years[] = date_format(date_create(date(APP_DATE_FORMAT)),'Y');
		}
		foreach ($years as $year){
			$months = $dbo->select('SELECT DISTINCT(month) FROM archived_complains WHERE year=:year', [":year" => $year]);
			while($m = array_shift($months)){
				$month_total = $dbo->count_row('archived_complains','WHERE year=:year AND month=:month',[":year" => $year, ":month" => $m['month']]);
		?>
        <!--Box Component-->
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title"><li class="time-label"><?php echo 'Year: ' . $year . ', ' . 'month: ' . $m['month'] . ', Total: ' . $month_total; ?></li></h3>
          </div>
          <!-- /box-header -->
          <div class="box-body">
            <table  class="table table-bordered table-striped">
              <thead>
                <tr>
                  <th>Category</th>
                  <th>No. of Complains</th>
                </tr>
              </thead>
              <tbody>
                <?php
				  $rows=$dbo->select('SELECT category_id, COUNT(category_id) as no_of_complain FROM `archived_complains` WHERE year=:year AND month=:month GROUP by category_id',[":year" => $year, ":month" => $m['month']]);
                  while($row=array_shift($rows)){ ?>
                  <tr>
                    <td><?php echo $dbo->row('complain_categories','WHERE id=:id',[":id" => $row['category_id']])['complain_category']; ?></td>
                      <td><?php echo $row['no_of_complain']; ?></td>
                          </tr>
                          <?php	} /*End of Loop*/ ?>
                          </tbody>
                        </table>
                      </div>
                      <!-- /box-body -->
                    </div>
                    <!-- /box -->
					<?php }} ?>
                  </div>
                  <!--/col-xs-12-->
                </div>
                <!--/row -->
				</section>
				<!-- /content -->
				<?php include 'footer.php'; ?>